#ifndef GRAPHICS_H
#define GRAPHICS_H

#include "game.h"
#include "gfx/bg_menu.h"

// Display control and mode definitions
#define MODE0      0x0000
#define BG0_ENABLE 0x0100
#define OBJ_ENABLE 0x1000
#define OBJ_1D_MAP 0x0040

// Memory-mapped I/O addresses for graphics
#define BG_PAL      ((volatile u16*)0x05000000)
#define BG0CNT      *(volatile u16*)0x04000008
#define VRAM_BG     ((volatile u16*)0x06000000)
#define BG_MAP      ((volatile u16*)0x06000800)
#define VRAM_OBJ    ((volatile u16*)0x06010000)
#define PAL_OBJ     ((volatile u16*)0x05000200)

// External declarations for palette and tile sets
extern const u16 originalPal[16];
extern const u16 BG_MENU_TILE_1[4];
extern const u16 BG_MENU_TILE_2[4];
extern const u16 BG_MENU_TILE_3[4];
extern const u16 BG_MENU_TILE_4[4];

// External declaration for shadow OAM
extern OAMEntry shadowOAM[128];

// Function declarations for graphics initialization and management
void initGraphics(void);
void initLevelGraphics(void);

// Function declarations for sprite management
void setSprite(int index, int x, int y, int tile);
void hideSprite(int index);
void setSpriteWithPriority(int index, int x, int y, int tile, int priority);
void updateOAM(void);

// Function declarations for palette and fading effects
void storeOriginalPalettes(void);
void fadeToBlack(int steps);
void fadeFromBlack(int steps);

// Function declarations for timing and background rendering
void delay(int frames);
void fillBackground(void);
void fillBackgroundWithTileset(const u16* tileSet1, const u16* tileSet2, const u16* tileSet3, const u16* tileSet4);

// Function declarations for level-specific graphics
void updateCounter(int coinCount, int guiX, int guiY);
void resetSprites(Wall* walls, int wallCount, LevelObject* objects, int objectCount, int guiX, int guiY, int coinCount);
void playSpawnAnimation(int x, int y, int* spawnTiles);
void resetGraphicsForLevel(WorldType worldType);
void loadLevelTileset(WorldType worldType);
void loadBackgroundTileset(WorldType worldType);

#endif